/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import net.sf.sockettest.swing.SocketTestClient;

public class SocketClient
extends Thread {
    private static SocketClient socketClient = null;
    private Socket socket = null;
    private SocketTestClient parent;
    private BufferedInputStream in;
    private boolean desonnected = false;

    public synchronized void setDesonnected(boolean bl) {
        this.desonnected = bl;
    }

    private SocketClient(SocketTestClient socketTestClient, Socket socket) {
        super("SocketClient");
        this.parent = socketTestClient;
        this.socket = socket;
        this.setDesonnected(false);
        this.start();
    }

    public static synchronized SocketClient handle(SocketTestClient socketTestClient, Socket socket) {
        if (socketClient == null) {
            socketClient = new SocketClient(socketTestClient, socket);
        } else {
            if (SocketClient.socketClient.socket != null) {
                try {
                    SocketClient.socketClient.socket.close();
                }
                catch (Exception exception) {
                    socketTestClient.error(exception.getMessage());
                }
            }
            SocketClient.socketClient.socket = null;
            socketClient = new SocketClient(socketTestClient, socket);
        }
        return socketClient;
    }

    public void run() {
        InputStream inputStream = null;
        try {
            inputStream = this.socket.getInputStream();
            this.in = new BufferedInputStream(inputStream);
        }
        catch (IOException iOException) {
            try {
                this.socket.close();
            }
            catch (IOException iOException2) {
                System.err.println("Socket not closed :" + iOException2);
            }
            this.parent.error("Could not open socket : " + iOException.getMessage());
            this.parent.disconnect();
            return;
        }
        while (!this.desonnected) {
            try {
                String string = SocketClient.readInputStream(this.in);
                if (string == null) {
                    this.parent.disconnect();
                    break;
                }
                this.parent.appendnoNewLine(string);
            }
            catch (IOException iOException) {
                if (this.desonnected) break;
                this.parent.error(iOException.getMessage(), "Connection lost");
                this.parent.disconnect();
                break;
            }
        }
        try {
            inputStream.close();
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    private static String readInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        String string = "";
        int n = bufferedInputStream.read();
        if (n == -1) {
            return null;
        }
        string = string + "" + (char)n;
        int n2 = bufferedInputStream.available();
        System.out.println("Len got : " + n2);
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            bufferedInputStream.read(byArray);
            string = string + new String(byArray);
        }
        return string;
    }
}

