/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest;

import java.awt.Container;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.sf.sockettest.Util;
import net.sf.sockettest.swing.About;
import net.sf.sockettest.swing.SocketTestClient;
import net.sf.sockettest.swing.SocketTestServer;
import net.sf.sockettest.swing.SocketTestUdp;
import net.sf.sockettest.swing.SplashScreen;

public class SocketTest
extends JFrame {
    private ClassLoader cl = this.getClass().getClassLoader();
    public ImageIcon logo = new ImageIcon(this.cl.getResource("icons/logo.gif"));
    public ImageIcon ball = new ImageIcon(this.cl.getResource("icons/ball.gif"));
    private JTabbedPane tabbedPane;

    public SocketTest() {
        Container container = this.getContentPane();
        this.tabbedPane = new JTabbedPane(1);
        SocketTestClient socketTestClient = new SocketTestClient(this);
        SocketTestServer socketTestServer = new SocketTestServer(this);
        SocketTestUdp socketTestUdp = new SocketTestUdp(this);
        About about = new About();
        this.tabbedPane.addTab("Client", this.ball, socketTestClient, "Test any server");
        this.tabbedPane.addTab("Server", this.ball, socketTestServer, "Test any client");
        this.tabbedPane.addTab("Udp", this.ball, socketTestUdp, "Test any UDP Client or Server");
        this.tabbedPane.addTab("About", this.ball, about, "About SocketTest");
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        container.add(this.tabbedPane);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
        }
        catch (Exception exception) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception2) {
                System.out.println("Error setting native LAF: " + exception2);
            }
        }
        boolean bl = true;
        if (stringArray.length > 0 && "nosplash".equals(stringArray[0])) {
            bl = false;
        }
        SplashScreen splashScreen = null;
        if (bl) {
            splashScreen = new SplashScreen();
        }
        SocketTest socketTest = new SocketTest();
        socketTest.setTitle("SocketTest v 3.0.0");
        socketTest.setSize(600, 500);
        Util.centerWindow(socketTest);
        socketTest.setDefaultCloseOperation(3);
        socketTest.setIconImage(socketTest.logo.getImage());
        if (bl) {
            splashScreen.kill();
        }
        socketTest.setVisible(true);
    }
}

