/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import net.sf.sockettest.swing.SocketTestServer;

public class SocketServer
extends Thread {
    private static SocketServer socketServer = null;
    private Socket socket = null;
    private ServerSocket server = null;
    private SocketTestServer parent;
    private BufferedInputStream in;
    private boolean desonnected = false;
    private boolean stop = false;

    public synchronized void setDesonnected(boolean bl) {
        if (this.socket != null && bl) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                System.err.println("Error closing clinet : setDesonnected : " + exception);
            }
        }
        this.desonnected = bl;
    }

    public synchronized void setStop(boolean bl) {
        this.stop = bl;
        if (this.server != null && bl) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                System.err.println("Error closing server : setStop : " + exception);
            }
        }
    }

    private SocketServer(SocketTestServer socketTestServer, ServerSocket serverSocket) {
        super("SocketServer");
        this.parent = socketTestServer;
        this.server = serverSocket;
        this.setStop(false);
        this.setDesonnected(false);
        this.start();
    }

    public static synchronized SocketServer handle(SocketTestServer socketTestServer, ServerSocket serverSocket) {
        if (socketServer == null) {
            socketServer = new SocketServer(socketTestServer, serverSocket);
        } else {
            if (SocketServer.socketServer.server != null) {
                try {
                    socketServer.setDesonnected(true);
                    socketServer.setStop(true);
                    if (SocketServer.socketServer.socket != null) {
                        SocketServer.socketServer.socket.close();
                    }
                    if (SocketServer.socketServer.server != null) {
                        SocketServer.socketServer.server.close();
                    }
                }
                catch (Exception exception) {
                    socketTestServer.error(exception.getMessage());
                }
            }
            SocketServer.socketServer.server = null;
            SocketServer.socketServer.socket = null;
            socketServer = new SocketServer(socketTestServer, serverSocket);
        }
        return socketServer;
    }

    public void run() {
        while (!this.stop) {
            try {
                this.socket = this.server.accept();
            }
            catch (Exception exception) {
                if (this.stop) continue;
                this.parent.error(exception.getMessage(), "Error acception connection");
                this.stop = true;
                continue;
            }
            this.startServer();
            if (this.socket == null) continue;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                System.err.println("Erro closing client socket : " + exception);
            }
            this.socket = null;
            this.parent.setClientSocket(this.socket);
        }
    }

    private void startServer() {
        block7: {
            this.parent.setClientSocket(this.socket);
            InputStream inputStream = null;
            this.parent.append("> New Client: " + this.socket.getInetAddress().getHostAddress());
            try {
                inputStream = this.socket.getInputStream();
                this.in = new BufferedInputStream(inputStream);
            }
            catch (IOException iOException) {
                this.parent.append("> Cound't open input stream on Clinet " + iOException.getMessage());
                this.setDesonnected(true);
                return;
            }
            String string = null;
            while (true) {
                string = null;
                try {
                    string = SocketServer.readInputStream(this.in);
                }
                catch (Exception exception) {
                    this.setDesonnected(true);
                    if (!this.desonnected) {
                        this.parent.error(exception.getMessage(), "Lost Client conection");
                        this.parent.append("> Server lost Client conection.");
                    } else {
                        this.parent.append("> Server closed Client conection.");
                    }
                    break block7;
                }
                if (string == null) break;
                this.parent.appendnoNewLine(string);
            }
            this.setDesonnected(true);
            this.parent.append("> Client closed conection.");
        }
    }

    private static String readInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        String string = "";
        int n = bufferedInputStream.read();
        if (n == -1) {
            return null;
        }
        string = string + "" + (char)n;
        int n2 = bufferedInputStream.available();
        System.out.println("Len got : " + n2);
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            bufferedInputStream.read(byArray);
            string = string + new String(byArray);
        }
        return string;
    }
}

