/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sockettest;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import net.sf.sockettest.swing.SocketTestUdp;

public class UdpServer
extends Thread {
    public static int BUFFER_SIZE = 1024;
    private static UdpServer udpServer = null;
    private static UdpServer udpServer2 = null;
    private DatagramSocket server;
    private SocketTestUdp parent;
    private boolean stop = false;
    private byte[] buffer = new byte[BUFFER_SIZE];

    public synchronized void setStop(boolean bl) {
        this.stop = bl;
        if (this.server != null && bl) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                System.err.println("Error closing server : setStop : " + exception);
            }
        }
    }

    private UdpServer(SocketTestUdp socketTestUdp, DatagramSocket datagramSocket) {
        super("SocketUdp");
        this.parent = socketTestUdp;
        this.server = datagramSocket;
        this.setStop(false);
        this.start();
    }

    public static synchronized UdpServer handle(SocketTestUdp socketTestUdp, DatagramSocket datagramSocket) {
        if (udpServer == null) {
            udpServer = new UdpServer(socketTestUdp, datagramSocket);
        } else {
            if (UdpServer.udpServer.server != null) {
                try {
                    udpServer.setStop(true);
                    if (UdpServer.udpServer.server != null) {
                        UdpServer.udpServer.server.close();
                    }
                }
                catch (Exception exception) {
                    socketTestUdp.error(exception.getMessage());
                }
            }
            UdpServer.udpServer.server = null;
            udpServer = new UdpServer(socketTestUdp, datagramSocket);
        }
        return udpServer;
    }

    public static synchronized UdpServer handleClient(SocketTestUdp socketTestUdp, DatagramSocket datagramSocket) {
        if (udpServer2 == null) {
            udpServer2 = new UdpServer(socketTestUdp, datagramSocket);
        } else {
            if (UdpServer.udpServer2.server != null) {
                try {
                    udpServer2.setStop(true);
                    if (UdpServer.udpServer2.server != null) {
                        UdpServer.udpServer2.server.close();
                    }
                }
                catch (Exception exception) {
                    socketTestUdp.error(exception.getMessage());
                }
            }
            UdpServer.udpServer2.server = null;
            udpServer2 = new UdpServer(socketTestUdp, datagramSocket);
        }
        return udpServer2;
    }

    public void run() {
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer, this.buffer.length);
        while (!this.stop) {
            try {
                this.server.receive(datagramPacket);
                if (udpServer != null) {
                    if (this.server == UdpServer.udpServer.server) {
                        this.parent.append("R[" + datagramPacket.getAddress().getHostAddress() + ":" + datagramPacket.getPort() + "]: " + new String(datagramPacket.getData(), 0, datagramPacket.getLength()));
                        continue;
                    }
                    this.parent.append("R: " + new String(datagramPacket.getData(), 0, datagramPacket.getLength()));
                    continue;
                }
                this.parent.append("R: " + new String(datagramPacket.getData(), 0, datagramPacket.getLength()));
            }
            catch (Exception exception) {
                if (this.stop) continue;
                this.parent.error(exception.getMessage(), "Error acception connection");
                this.stop = true;
            }
        }
    }
}

