#include <form.h>
#include <stdio.h>
#include "macro.h"

FIELD *field[FIELD_CNT+1]; //The last one must be NULL
FORM *my_form;
void HighLightCurrent() {
	int idx;
    for(idx=0;idx<FIELD_CNT;idx++) {
        set_field_fore(field[idx], COLOR_PAIR(2));// set field bg color
        set_field_back(field[idx], COLOR_PAIR(2));// set field fore color
        field_opts_off(field[idx], O_AUTOSKIP); // No go to next field when this
	}
	idx = field_index(current_field(my_form));
	set_field_fore(field[idx],COLOR_PAIR(1));
	set_field_back(field[idx],COLOR_PAIR(1));
}
void SetMessage(char *buf) {
	char msg[50];
	memset(msg,0x20,sizeof(msg));
	msg[49]=0;
    mvprintw(0,10,msg);
	mvprintw(0,10,buf);
}
void SetResult(char *buf) {
    char msg[50];
    memset(msg,0x20,sizeof(msg));
    msg[49]=0;
    mvprintw(1,10,msg);
    mvprintw(1,10,buf);
}
int dbg_form_init() {
	int idx,ch;
	/* Initialize curses */
	initscr();
	start_color();
	cbreak();
	noecho();
	keypad(stdscr, TRUE);

	/* Initialize few color pairs */
	init_pair(1, COLOR_WHITE, COLOR_BLUE);
	init_pair(2, COLOR_WHITE, COLOR_BLACK);

	/* Initialize the fields */
	for(idx=0;idx<FIELD_CNT;idx++) {
		field[idx] = new_field(1, 8, FIELD_Y_BASE+idx, 11, 0, 0);
		//                                 Y             X
	}
	field[FIELD_CNT] = NULL; //The last one must be null

	/* Set field options */
	for(idx=0;idx<FIELD_CNT;idx++) {
		set_field_fore(field[idx], COLOR_PAIR(1));// set field bg color 
		set_field_back(field[idx], COLOR_PAIR(1));// set field fore color
		field_opts_off(field[idx], O_AUTOSKIP); // No go to next field when this
	}

	/* Create the form and post it */
	my_form = new_form(field);
	post_form(my_form);
	refresh();
	
	set_current_field(my_form, field[0]); /* Set focus to the colored field */
	mvprintw(0,0,"Message : ");
	mvprintw(1,0," Result : ");
	mvprintw(FIELD_Y_BASE,   0, "   CR_NAME:");
	mvprintw(FIELD_Y_BASE+1, 0, "  CR_VALUE:");
    mvprintw(FIELD_Y_BASE+2, 0, " ADDR_NAME:");
    mvprintw(FIELD_Y_BASE+3, 0, "ADDR_VALUE:");

	mvprintw(LINES - 2, 0, HELPMSG);
	refresh();

}
	/* Un post form and free the memory */
int dbg_form_end() {

	unpost_form(my_form);
	free_form(my_form);
	free_field(field[0]);
	free_field(field[1]); 

	endwin();
	return 0;
}
