#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <netinet/in.h>

#include <linux/sockios.h>
#include "menu_drv_macro.h"


struct zdap_ioctl {
	unsigned short cmd;                /* Command to run */
	unsigned long addr;                /* Length of the data buffer */
	unsigned long value;               /* Pointer to the data buffer */
	unsigned char data[0x100];
};

static char prgname[]="ioctl_get";

static int set_ioctl(int sock, struct ifreq *req)
{
	
	struct zdap_ioctl *myreq = (struct zdap_ioctl *)req->ifr_data;

    if (ioctl(sock, ZD_MENU_DBG, req) < 0) {
        fprintf(stderr, "%s: ioctl(SIOCGIFMAP): %s\n",
                prgname, strerror(errno));
        return -1;
    }
	
    return *(int *)myreq->data;
}


int gDevVal(char *ifname,char *cmd, int addr,int value)
{
    int sock;
    struct ifreq req;
    char *action = NULL;
    struct zdap_ioctl zdreq;
	int ret;
    

    strcpy(req.ifr_name, ifname);
    zdreq.addr = 0;
    zdreq.value = 0;

    /* a silly raw socket just for ioctl()ling it */
    sock = socket(AF_INET, SOCK_RAW, IPPROTO_RAW);
    if (sock < 0) {
        fprintf(stderr, "socket(): %s\n",  strerror(errno));
        exit(1);
    }

    zdreq.addr = addr;
    zdreq.value = value;
     
    if (!strcmp(cmd, "RDPhy")) {
        zdreq.cmd = RDPhy;
    }
    else if (!strcmp(cmd, "WRPhy")) {
        zdreq.cmd = WRPhy;
    }		
    else if (!strcmp(cmd, "RDMAC")) {
        zdreq.cmd = RDMAC;
    }	
    else if (!strcmp(cmd, "WRMAC")) {
        zdreq.cmd = WRMAC;
    }
    else if (!strcmp(cmd, "RDCNT")) {
        zdreq.cmd = RDCNT;
    }
    else {
		fprintf(stderr, "error action\n");
        exit(1);
    }

just_set:
	memset(zdreq.data,0x09,sizeof(zdreq.data));
    req.ifr_data = (char *)&zdreq;
    ret = set_ioctl(sock, &req);
	close(sock);
	return ret;

}

