#include <form.h>
#include <stdio.h>
#include "macro.h"
#include "TextForm.h"
#include "ioctl_op.h"
#include "utils.h"
#include "WRITE_Handler.h"
#include "READ_Handler.h"
#include "menu_drv_macro.h"

extern FIELD *field[FIELD_CNT+1]; //The last one must be NULL
extern FORM *my_form;
struct CNT_ELEMENT {
	char *name;
	int cmd;
	int value;
} ;

struct CNT_ELEMENT CNT_TBL[] = {
    { "T_bcnCnt",T_bcnCnt ,0},
    { "T_dtimCnt",T_dtimCnt ,0},
    { "T_txCmpCnt",T_txCmpCnt ,0},   
    { "T_rxCnt",T_rxCnt ,0},        
    { "T_retryFailCnt",T_retryFailCnt ,0},
    { "T_txCnt",T_txCnt ,0},
    { "T_txIdleCnt",T_txIdleCnt ,0},   
    { "T_rxIdleCnt",T_rxIdleCnt ,0},  
    { "T_rxDupCnt",T_rxDupCnt ,0},     
};

void ShowCNTTally(char *ifname) {
	char msg[1024];
	int y_offset=0;
	int value;
	int idx;

	for(idx=0;idx <sizeof(CNT_TBL)/sizeof(struct CNT_ELEMENT) && idx<20;idx++) {
		value = gDevVal(ifname,"RDCNT",CNT_TBL[idx].cmd,0);
		sprintf(msg,"%14s = %08x",CNT_TBL[idx].name,value-CNT_TBL[idx].value);
		CNT_TBL[idx].value=value;
		mvprintw(CNT_TALLY_Y+y_offset++, CNT_TALLY_X,msg);
	}
	y_offset=0;
    for(idx=20;idx <sizeof(CNT_TBL)/sizeof(struct CNT_ELEMENT) ;idx++) {
        value = gDevVal(ifname,"RDCNT",CNT_TBL[idx].cmd,0);
        sprintf(msg,"%14s = %08x",CNT_TBL[idx].name,value-CNT_TBL[idx].value);
		CNT_TBL[idx].value=value;
        mvprintw(CNT_TALLY_Y+y_offset++, CNT_TALLY_X+25,msg);
    }


}

