#include <form.h>
#include <stdio.h>
#include "macro.h"
#include "TextForm.h"
#include "ioctl_op.h"
#include "utils.h"
#include "WRITE_Handler.h"
#include "READ_Handler.h"
#include "RegDefine.h"

extern FIELD *field[FIELD_CNT+1]; //The last one must be NULL
extern FORM *my_form;
struct REG_ELEMENT {
	char *name;
	int addr;
	int value;
} ;

struct REG_ELEMENT REG_TBL[] = {
	{"InterruptCtrl",InterruptCtrl,0},
	{"Rx_Filter",Rx_Filter,0},
	{"ReadTcbAddress",ReadTcbAddress,0},
	{"ReadRfdAddress",ReadRfdAddress,0},
	{"MACAddr_P1",MACAddr_P1,0},
	{"MACAddr_P2",MACAddr_P2,0},
	{"BCNInterval",BCNInterval,0},
	{"BCNPLCPCfg",BCNPLCPCfg,0},
	{"TSF_LowPart",TSF_LowPart,0},
	{"TSF_HighPart",TSF_HighPart,0},
	{"BCN_FIFO_Sem",BCN_FIFO_Semaphore,0},
	{"CtlReg1",CtlReg1,0},
	{"DeviceState",DeviceState,0},
	{"NAV_CCA",NAV_CCA,0},
	{"CRC32Cnt",CRC32Cnt,0},
	{"CRC16Cnt",CRC16Cnt,0},
	{"TotalRxFrm",TotalRxFrm,0},
	{"TotalTxFrm",TotalTxFrm,0},
	{"RxFIFOOverrun",RxFIFOOverrun,0},
	{"UnderrunCnt",UnderrunCnt,0},
	{"DecrypErr_UNI",DecrypErr_UNI,0},
	{"DecrypErr_Mul",DecrypErr_Mul,0},
	{"BSSID_P1",BSSID_P1,0},
	{"BSSID_P2",BSSID_P2,0},
	{"Pre_TBTT",Pre_TBTT,0},
	{"ATIMWndPeriod",ATIMWndPeriod,0},
	{"RetryCnt",RetryCnt,0},
	{"IFS_Value",IFS_Value,0},
	{"NAV_CNT",NAV_CNT,0},
	{"CWmin_CWmax",CWmin_CWmax,0},
	{"GroupHash_P1",GroupHash_P1,0},
	{"GroupHash_P2",GroupHash_P2,0},

};

void ShowRegTally(char *ifname) {
	char msg[1024];
	int y_offset=0;
	int value;
	int idx;

	for(idx=0;idx <sizeof(REG_TBL)/sizeof(struct REG_ELEMENT) && idx<20;idx++) {
		value = gDevVal(ifname,"RDMAC",REG_TBL[idx].addr,0);
		sprintf(msg,"%14s = %08x",REG_TBL[idx].name,value);
		mvprintw(REG_TALLY_Y+y_offset++, REG_TALLY_X,msg);
		REG_TBL[idx].value = value;
	}
	y_offset=0;
    for(idx=20;idx <sizeof(REG_TBL)/sizeof(struct REG_ELEMENT) ;idx++) {
        value = gDevVal(ifname,"RDMAC",REG_TBL[idx].addr,0);
        sprintf(msg,"%14s = %08x",REG_TBL[idx].name,value);
        mvprintw(REG_TALLY_Y+y_offset++, REG_TALLY_X+25,msg);
		REG_TBL[idx].value = value;
    }

	if(REG_TBL[17].value != 0)
		sprintf(msg,"%14s = %08x","Pkt Err Ratio",100*REG_TBL[26].value/REG_TBL[17].value);
	else
		sprintf(msg,"%14s = %08x","Pkt Err Ratio",0);
	mvprintw(REG_TALLY_Y+y_offset++, REG_TALLY_X+25,msg);


}


