#include <form.h>
#include <stdio.h>
#include "macro.h"
#include "TextForm.h"
#include "ioctl_op.h"
#include "utils.h"
#include "WRITE_Handler.h"
#include "READ_Handler.h"
#include "TallyReg.h"

extern FIELD *field[FIELD_CNT+1]; //The last one must be NULL
extern FORM *my_form;

int main(int argc, char *argv[])
{	
	int ret,ch;
	char *p;

	if(argc != 2) {
		fprintf(stderr,"Error number of parameters (!=2)\n");
		exit(1);
	}
	dbg_form_init();
	HighLightCurrent();
	/* Loop through to get user requests */
    while((ch = getch()) != 'q')
    {   
		switch(ch)
        {   case KEY_DOWN:
                /* Go to next field */
                form_driver(my_form, REQ_NEXT_FIELD);
                /* Go to the end of the present buffer */
                /* Leaves nicely at the last character */
                form_driver(my_form, REQ_END_LINE);
                break;
            case KEY_UP:
                /* Go to previous field */
                form_driver(my_form, REQ_PREV_FIELD);
                form_driver(my_form, REQ_END_LINE);
                break;
            case KEY_BACKSPACE:
	            form_driver(my_form, REQ_DEL_PREV);
                break;
			case KEY_RIGHT: //Write
				form_driver(my_form,REQ_VALIDATION);
				form_driver(my_form,0);
				Handle_WRITE(argv[1]);
				wrefresh(curscr);
				break;
            case KEY_LEFT: //Write
                form_driver(my_form,REQ_VALIDATION);
                form_driver(my_form,0);
                Handle_READ(argv[1]);
				wrefresh(curscr);
                break;
			case 'z':
                form_driver(my_form,REQ_VALIDATION);
                form_driver(my_form,0);
				ShowRegTally(argv[1]);
				wrefresh(curscr);
				break;
            case 'x':
                form_driver(my_form,REQ_VALIDATION);
                form_driver(my_form,0);
                ShowCNTTally(argv[1]);
				wrefresh(curscr);
                break;
            case 'l':
                form_driver(my_form,REQ_VALIDATION);
                form_driver(my_form,0);
                wrefresh(curscr);
                break;
            default:
                /* If this is a normal character, it gets */
                /* Printed                */
                form_driver(my_form, ch);
                break;
        }
		HighLightCurrent();
	}
	dbg_form_end();
}
